<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FetauredBlog extends Model
{
    use HasFactory;
    protected $fillable = [
        'blog_names',
        'start_date',
        'end_date'
    ];
    public function users()
    {
        return $this->belongsTo('App\User', 'user_id', 'id')->withDefault();
    }
    
    public function comments()
    {

        return $this->hasMany('App\Comment');
    }
    public function blog()
    {
        return $this->belongsTo('App\Blog', 'blog_names', 'id')->withDefault();
    }
}
